<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Default Filesystem Disk
    |--------------------------------------------------------------------------
    |
    | Here you may specify the default filesystem disk that should be used
    | by the framework. The "local" disk, as well as a variety of cloud
    | based disks are available to your application. Just store away!
    |
    */

    'default' => env('FILESYSTEM_DRIVER', 'local'),

    'cloud' => env('FILESYSTEM_CLOUD', 's3'),

    /*
    |--------------------------------------------------------------------------
    | Filesystem Disks
    |--------------------------------------------------------------------------
    |
    | Here you may configure as many filesystem "disks" as you wish, and you
    | may even configure multiple disks of the same driver. Defaults have
    | been setup for each driver as an example of the required options.
    |
    | Supported Drivers: "local", "ftp", "sftp", "s3"
    |
    */

    'disks' => [
        'local' => [
            'driver' => 'local',
            'root' => storage_path('app'),
        ],

        'root_url' => [
            'driver' => 'local',
            'root' => public_path('../../'),
            'url' => env('APP_URL').'/assets',
            'visibility' => 'root_url',
        ],

        'public' => [
            'driver' => 'local',
            'root' => storage_path('app/public'),
            'url' => env('APP_URL').'/storage',
            'visibility' => 'public',
        ],

        's3' => [
            'driver' => 's3',
            'key' => "",
            'secret' => "",
            'region' => "",
            'bucket' => "",
            'url' => "",
            'endpoint' => "",
            'use_path_style_endpoint' => false,
        ],

        'wasabi' => [
            'driver' => 's3',
            'key' => "",
            'secret' => "",
            'region' => "",
            'bucket' => "",
            'endpoint' => "",
        ],

        'LandlordMediaUploader' => [
            'driver' => 'local',
            'root' => storage_path('../../assets/landlord/uploads/media-uploader/'),
            'throw' => false,
        ],

        'TenantMediaUploader' => [
            'driver' => 'local',
            'root' => storage_path('../../assets/tenant/uploads/media-uploader/'),
            'throw' => false,
        ],

        'cloudFlareR2' => [
            'driver' => 's3',
            'key' => "",
            'secret' => "",
            'region' => 'us-east-1',
            'bucket' => "",
            'url' => "",
            'visibility' => 'private',
            'endpoint' => "",
            'use_path_style_endpoint' => false,
            'throw' => false,
        ]
    ],

    /*
    |--------------------------------------------------------------------------
    | Symbolic Links
    |--------------------------------------------------------------------------
    |
    | Here you may configure the symbolic links that will be created when the
    | `storage:link` Artisan command is executed. The array keys should be
    | the locations of the links and the values should be their targets.
    |
    */

    'links' => [
        public_path('storage') => storage_path('app/public'),
    ],
];
