<?php
    if (!isset($authors)) {
        $authors = [];
    }

    if (!isset($languages)) {
        $languages = [];
    }

    if (!isset($product))
    {
        $product = null;
    }
?>

<div class="general-info-wrapper px-3">
    <h4 class="dashboard-common-title-two"> <?php echo e(__('Product Additional Field Info')); ?> </h4>
    <div class="general-info-form mt-0 mt-lg-4">
            <div class="dashboard-input mt-4">
                <label class="dashboard-label color-light mb-2"> <?php echo e(__("Author")); ?> <sup class="text-primary"><?php echo e(__('(Optional)')); ?></sup></label>
                <select name="author_id" id="tax" class="form-control">
                    <option value=""><?php echo e(__('Select an author')); ?></option>
                    <?php $__currentLoopData = $authors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $author): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($author->id); ?>" <?php echo e($product?->additionalFields?->author_id == $author->id ? 'selected' : ''); ?>><?php echo e($author->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="dashboard-input mt-4">
                <label class="dashboard-label color-light mb-2"> <?php echo e(__("Pages")); ?> <sup class="text-primary"><?php echo e(__('(Optional)')); ?></sup></label>
                <input type="text" class="form--control radius-10" value="<?php echo e($product?->additionalFields?->pages); ?>" name="page"
                       placeholder="<?php echo e(__("Enter page number...")); ?>">
            </div>

            <div class="dashboard-input mt-4">
                <label class="dashboard-label color-light mb-2"> <?php echo e(__("Language")); ?> <sup class="text-primary"><?php echo e(__('(Optional)')); ?></sup></label>
                <select name="language" id="tax" class="form-control">
                    <option value=""><?php echo e(__('Select a language')); ?></option>
                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $author): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($author->id); ?>" <?php echo e($product?->additionalFields?->language == $author->id ? 'selected' : ''); ?>><?php echo e($author->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

        <div class="dashboard-input mt-4">
            <label class="dashboard-label color-light mb-2"> <?php echo e(__("Formats")); ?> <sup class="text-primary"><?php echo e(__('(Optional)')); ?></sup></label>
            <input type="text" class="form--control radius-10" value="<?php echo e($product?->additionalFields?->formats); ?>" name="formats"
                   placeholder="<?php echo e(__("Enter formats...")); ?>">
        </div>

        <div class="dashboard-input mt-4">
            <label class="dashboard-label color-light mb-2"> <?php echo e(__("Words")); ?> <sup class="text-primary"><?php echo e(__('(Optional)')); ?></sup></label>
            <input type="text" class="form--control radius-10" value="<?php echo e($product?->additionalFields?->words); ?>" name="word"
                   placeholder="<?php echo e(__("Enter words...")); ?>">
        </div>

        <div class="dashboard-input mt-4">
            <label class="dashboard-label color-light mb-2"> <?php echo e(__("Tool Used")); ?> <sup class="text-primary"><?php echo e(__('(Optional)')); ?></sup></label>
            <input type="text" class="form--control radius-10" value="<?php echo e($product?->additionalFields?->tool_used); ?>" name="tool_used"
                   placeholder="<?php echo e(__("Enter tool names...")); ?>">
        </div>

        <div class="dashboard-input mt-4">
            <label class="dashboard-label color-light mb-2"> <?php echo e(__("Database Used")); ?> <sup class="text-primary"><?php echo e(__('(Optional)')); ?></sup></label>
            <input type="text" class="form--control radius-10" value="<?php echo e($product?->additionalFields?->database_used); ?>" name="database_used"
                   placeholder="<?php echo e(__("Enter database names...")); ?>">
        </div>

        <div class="dashboard-input mt-4">
            <label class="dashboard-label color-light mb-2"> <?php echo e(__("Compatible Browsers")); ?> <sup class="text-primary"><?php echo e(__('(Optional)')); ?></sup></label>
            <input type="text" class="form--control radius-10" value="<?php echo e($product?->additionalFields?->compatible_browsers); ?>" name="compatible_browsers"
                   placeholder="<?php echo e(__("Enter compatible browser names...")); ?>">
        </div>

        <div class="dashboard-input mt-4">
            <label class="dashboard-label color-light mb-2"> <?php echo e(__("Compatible OS")); ?> <sup class="text-primary"><?php echo e(__('(Optional)')); ?></sup></label>
            <input type="text" class="form--control radius-10" value="<?php echo e($product?->additionalFields?->compatible_os); ?>" name="compatible_os"
                   placeholder="<?php echo e(__("Enter compatible os names...")); ?>">
        </div>

        <div class="dashboard-input mt-4">
            <label class="dashboard-label color-light mb-2"> <?php echo e(__("High Resolution")); ?> <sup class="text-primary"><?php echo e(__('(Optional)')); ?></sup></label>
            <select name="high_resolution" id="high_resolution" class="form-control">
                <option value=""><?php echo e(__('Select an option')); ?></option>
                <option value="yes" <?php echo e($product?->additionalFields?->high_resolution == 'yes' ? 'selected' : ''); ?>><?php echo e(__('Yes')); ?></option>
                <option value="no" <?php echo e($product?->additionalFields?->high_resolution == 'no' ? 'selected' : ''); ?>><?php echo e(__('No')); ?></option>
            </select>
        </div>
    </div>

    <h4 class="dashboard-common-title-two mt-5"> <?php echo e(__('Product Additional Custom Field Info')); ?> <sup class="text-primary"><?php echo e(__('(Optional)')); ?></sup> </h4>
    <div class="general-info-form mt-0 mt-lg-4">
        <?php
            $custom_fields = $product?->additionalCustomFields ?? [];
        ?>

        <?php if(count($custom_fields) > 0): ?>
            <?php $__currentLoopData = $custom_fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="row mt-4 custom-additional-field-row">
                    <div class="col-5">
                        <input type="text" class="form--control radius-10" value="<?php echo e($field->option_name); ?>" name="option_name[]"
                               placeholder="<?php echo e(__("Option Name")); ?>">
                    </div>
                    <div class="col-5">
                        <input type="text" class="form--control radius-10" value="<?php echo e($field->option_value); ?>" name="option_value[]"
                               placeholder="<?php echo e(__("Option Value")); ?>">
                    </div>
                    <div class="col-2">
                        <div class="custom-button d-flex gap-3">
                            <a class="btn btn-info custom-plus" href="javascript:void(0)"><span class="mdi mdi-plus"></span></a>
                            <a class="btn btn-danger custom-minus" href="javascript:void(0)"><span class="mdi mdi-minus"></span></a>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <div class="row custom-additional-field-row">
                <div class="col-5">
                    <input type="text" class="form--control radius-10" value="" name="option_name[]"
                           placeholder="<?php echo e(__("Option Name")); ?>">
                </div>
                <div class="col-5">
                    <input type="text" class="form--control radius-10" value="" name="option_value[]"
                           placeholder="<?php echo e(__("Option Value")); ?>">
                </div>
                <div class="col-2">
                    <div class="custom-button d-flex gap-3">
                        <a class="btn btn-info custom-plus" href="javascript:void(0)"><span class="mdi mdi-plus"></span></a>
                        <a class="btn btn-danger custom-minus" href="javascript:void(0)"><span class="mdi mdi-minus"></span></a>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH /data/sdmkinga/ecommerce-v4.sdmkingagroup.com/core/Modules/DigitalProduct/Resources/views/components/product-additional-field.blade.php ENDPATH**/ ?>