<?php $__env->startSection('title'); ?>
    <?php echo e(__('Payment Logs')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('section'); ?>
    <?php if(count($order_list) > 0): ?>
        <div class="table-responsive">
            <!-- Order history start-->
            <div class="order-history-inner">
                <table>
                    <thead>
                    <tr>
                        <th>
                            <?php echo e(__('Order ID')); ?>

                        </th>
                        <th>
                            <?php echo e(__('Date')); ?>

                        </th>
                        <th>
                            <?php echo e(__('Status')); ?>

                        </th>

                        <th>
                            <?php echo e(__('Amount')); ?>

                        </th>
                        <th>
                            <?php echo e(__('Action')); ?>

                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $order_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="completed">
                            <td class="order-numb">
                                #<?php echo e($data->id ?? 0); ?>

                            </td>
                            <td class="date">
                                <?php echo e($data->created_at->format("d M, Y")); ?>

                            </td>
                            <?php
                                $text_color = ['default' => 'text-dark' ,'success' => 'text-success', 'complete' => 'text-success', 'cancel' => 'text-danger', 'pending' => 'text-warning'];
                            ?>
                            <td class="status">
                                <p>
                                    <span><?php echo e(__('Order Status:')); ?></span>
                                    <span class="<?php echo e($text_color[$data->status ?? 'default']); ?>"><?php echo e(__($data->status) ?? ""); ?></span>
                                </p>
                                <p>
                                    <span><?php echo e(__('Payment Status:')); ?></span>
                                    <span class="<?php echo e($text_color[$data->payment_status ?? 'default']); ?>"><?php echo e(__($data->payment_status) ?? ""); ?></span>
                                </p>
                            </td>

                            <td class="amount">
                                <?php echo e(amount_with_currency_symbol($data->total_amount)); ?>

                            </td>
                            <td class="table-btn">
                                <div class="d-flex gap-2">
                                    <div class="btn-wrapper">
                                        <a href="<?php echo e(route('tenant.user.dashboard.package.order', $data->id)); ?>" class="btn-default rounded-btn"><?php echo e(__('Details')); ?></a>
                                    </div>

                                    <?php if($data->status === 'pending'): ?>
                                        <div class="btn-wrapper">
                                            <form class="order-cancel-form" action="<?php echo e(route('tenant.user.dashboard.order.change.status')); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="order_id" value="<?php echo e($data->id); ?>">
                                                <button type="submit" class="btn-default rounded-btn cancel-btn"><?php echo e(__('Cancel')); ?> <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.btn.button-loader','data' => ['class' => 'd-none']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('btn.button-loader'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'd-none']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?></button>
                                            </form>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <!-- Order history end-->
        </div>
        <div class="blog-pagination">
            <?php echo e($order_list->links()); ?>

        </div>
    <?php else: ?>
        <div class="alert alert-warning"><?php echo e(__('No Order Found')); ?></div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).on('click', '.cancel-btn', function (e) {
            e.preventDefault();

            Swal.fire({
                title: "<?php echo e(__('Do you want to cancel this order?')); ?>",
                showCancelButton: true,
                confirmButtonText: `<?php echo e(__('Confirm')); ?>`,
                confirmButtonColor: '#dd3333',
            }).then((result) => {
                if (result.isConfirmed) {
                    let el = $(this);
                    el.find('.loading-icon').removeClass('d-none');
                    el.find('.loading-icon').attr('disabled', true);
                    el.parents('form.order-cancel-form').submit();
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('tenant.frontend.user.dashboard.user-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /data/sdmkinga/ecommerce-v4.sdmkingagroup.com/core/resources/views/tenant/frontend/user/dashboard/order-list.blade.php ENDPATH**/ ?>