<?php
    if(!isset($product)){
        $product = null;
    }
?>

<div class="general-info-wrapper">
    <h4 class="dashboard-common-title-two"> <?php echo e(__("General Information")); ?> </h4>
    <div class="general-info-form mt-0 mt-lg-4">
        <form action="#">
            <div class="dashboard-input mt-4">
                <label class="dashboard-label color-light mb-2"> <?php echo e(__("Name")); ?> </label>
                <input type="text" class="form--control radius-10" id="product-name" value="<?php echo e($product?->name ?? ""); ?>" name="name" placeholder="<?php echo e(__("Write product Name...")); ?>">
            </div>

            <div class="dashboard-input mt-4">
                <label class="dashboard-label color-light mb-2"> <?php echo e(__("Slug")); ?> </label>
                <input type="text" class="form--control radius-10" id="product-slug" value="<?php echo e($product?->slug ?? ""); ?>" name="slug" placeholder="<?php echo e(__("Write product slug...")); ?>">
            </div>

            <div class="dashboard-input mt-4">
                <label class="dashboard-label color-light mb-2"> <?php echo e(__("Summary")); ?> </label>
                <textarea style="height: 120px" class="form--control form--message  radius-10"  name="summary" placeholder="<?php echo e(__("Write product Summary...")); ?>"><?php echo e($product?->summary ?? ""); ?></textarea>
            </div>

            <div class="dashboard-input mt-4">
                <label class="dashboard-label color-light mb-2"> <?php echo e(__("Description")); ?> </label>
                <textarea class="form--control summernote radius-10" name="description" placeholder="<?php echo e(__("Type Description")); ?>"><?php echo purify_html($product?->description ?? ""); ?></textarea>
            </div>

            <div class="dashboard-input mt-4">
                <label class="dashboard-label color-light mb-2"> <?php echo e(__("Included files")); ?> <sup class="text-primary"><?php echo e(__('Optional')); ?></sup> </label>
                <input type="text" class="form--control radius-10" id="included_file" value="<?php echo e($product?->included_files ?? ""); ?>" name="included_files" placeholder="<?php echo e(__("Write included file names...")); ?>">
            </div>

            <div class="dashboard-input mt-4">
                <label class="dashboard-label color-light mb-2"> <?php echo e(__("Version")); ?> <sup class="text-primary"><?php echo e(__('(Optional)')); ?></sup> </label>
                <input type="text" class="form--control radius-10" id="version" value="<?php echo e($product?->version ?? ""); ?>" name="version" placeholder="<?php echo e(__("Write version number...")); ?>">
            </div>

            <div class="dashboard-input mt-4">
                <label class="dashboard-label color-light mb-2"> <?php echo e(__("Release Date")); ?> <sup class="text-primary"><?php echo e(__('(Optional)')); ?></sup> </label>
                <input type="date" class="form--control radius-10 flatpickr" id="release_date" value="<?php echo e($product?->release_date ?? ""); ?>" name="release_date" placeholder="<?php echo e(__("Write release date...")); ?>">
            </div>

            <div class="dashboard-input mt-4">
                <label class="dashboard-label color-light mb-2"> <?php echo e(__("Latest Update")); ?> <sup class="text-primary"><?php echo e(__('(Optional)')); ?></sup> </label>
                <input type="date" class="form--control radius-10 flatpickr" id="latest_date" value="<?php echo e($product?->update_date ?? ""); ?>" name="update_date" placeholder="<?php echo e(__("Write latest update...")); ?>">
            </div>

            <div class="dashboard-input mt-4">
                <label class="dashboard-label color-light mb-2"> <?php echo e(__("Preview Link")); ?> <sup class="text-primary"><?php echo e(__('(Optional)')); ?></sup> </label>
                <input type="text" class="form--control radius-10" id="preview_link" value="<?php echo e($product?->preview_link ?? ""); ?>" name="preview_link" placeholder="<?php echo e(__("Write preview link...")); ?>">
            </div>

            <div class="dashboard-input mt-4">
                <label class="dashboard-label color-light mb-2"> <?php echo e(__("Quantity")); ?> <sup class="text-primary"><?php echo e(__('(Optional - If applicable)')); ?></sup> </label>
                <input type="text" class="form--control radius-10" id="quantity" value="<?php echo e($product?->quantity ?? ""); ?>" name="quantity" placeholder="<?php echo e(__("Write quantity...")); ?>">
            </div>
        </form>
    </div>
</div>
<?php /**PATH /data/sdmkinga/ecommerce-v4.sdmkingagroup.com/core/Modules/DigitalProduct/Resources/views/components/general-info.blade.php ENDPATH**/ ?>