<?php $__env->startSection('title'); ?>
    <?php echo e(__('Shipping Plugin')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
    <style>
        td *, th, td{
            text-align: left;
        }
        .tableWrap {
            overflow-x: auto;
        }
        .head-table{
            background-color: #fff9ec;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }

        .body-table {
            border-collapse: separate;
            border-spacing: 0 10px;
        }
        .body-table tr {
            border-spacing: 0 5px;
        }

        th {
            background-color: #f6f6f6;
            padding: 8px;
            color: #444;
        }

        td {
            text-align: left;
            padding: 8px;
            font-weight: 400;
            color: #666;
            min-width: 60px;
        }

        .head-table td {
            padding:  20px;
        }
        .head-table td p {
            font-size: 16px;
            font-weight: 400;
            line-height: 20px;
            color: #666;
        }
        .head-table td p:not(:last-child) {
            margin-bottom: 5px;
        }
        .head-table td p strong {
            color: #444;
        }

        .order-link{
            text-decoration: none;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="dashboard-recent-order">
        <div class="row">
            <div class="col-md-12">
                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.flash-msg','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('flash-msg'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.error-msg','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('error-msg'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                <div class="p-4 recent-order-wrapper dashboard-table bg-white padding-30">
                    <div class="wrapper d-flex justify-content-between">
                        <div class="header-wrap">
                            <h4 class="header-title mb-2"><?php echo e(__("Order Tracking")); ?></h4>
                            <p><?php echo e(__('Track your order using the waybill/housebill/tracking number')); ?></p>
                        </div>
                    </div>

                    <div class="body-wrap my-4">
                        <form action="<?php echo e(route('tenant.admin.shipping.plugin.track')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <label for="tracking_number"><?php echo e(__('Waybill or Tracking Number')); ?></label>
                                <input type="text" class="form-control" id="tracking_number" name="tracking_number"
                                       placeholder="<?php echo e(__('eg: 6458412354')); ?>">
                            </div>

                            <div class="form-group text-end">
                                <button class="btn btn-success" type="submit"><?php echo e(__('Track')); ?>

                                    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.btn.button-loader','data' => ['class' => 'd-none']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('btn.button-loader'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'd-none']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <?php if(session('tracking_data')): ?>
                    <?php
                        $tracking_data = session('tracking_data');
                    ?>

                    <?php echo $__env->make("shippingplugin::backend.track-table.{$tracking_data['gateway']}", $tracking_data, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <?php if($has_orders): ?>
        <div class="dashboard-recent-order mt-5">
            <div class="row">
                <div class="col-md-12">

                    <div class="p-4 recent-order-wrapper dashboard-table bg-white padding-30">
                        <div class="wrapper d-flex justify-content-between">
                            <div class="header-wrap">
                                <h4 class="header-title mb-2"><?php echo e(__("Order Creation Statuses")); ?></h4>
                                <p><?php echo e(__("All order list created through API from this platform")); ?></p>
                            </div>
                        </div>

                        <div class="body-wrap my-4">
                            <table>
                                <thead>
                                    <th><?php echo e(__('ID')); ?></th>
                                    <th><?php echo e(__('Order ID')); ?></th>
                                    <th><?php echo e(__('Gateway')); ?></th>
                                    <th><?php echo e(__('Status')); ?></th>
                                    <th><?php echo e(__('Message')); ?></th>
                                    <th><?php echo e(__('Date Time')); ?></th>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $orders ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php
                                            $info = [];
                                            $message = $order->message;
                                            if ($order->status === 'success')
                                                {
                                                    $message = json_decode($message);
                                                    if ($message):
                                                    $info = [
                                                            'message' => __('Order creation successful'),
                                                            'shipping_order_id' => $message->order_id,
                                                            'channel_order_id' => $message->channel_order_id,
                                                            'shipment_id' => $message->shipment_id,
                                                        ];
                                                    endif;
                                                }
                                            else {
                                                $array_text = str_split($message);

                                                for($i=0; $i<count($array_text); $i++)
                                                    {
                                                        if ($array_text[$i] != '{')
                                                            {
                                                                $array_text[$i] = null;
                                                            }
                                                        else
                                                            {
                                                                break;
                                                            }
                                                    }

                                                $flag = false;
                                                for($i=count($array_text)-1; $i>=0; $i--)
                                                    {
                                                        if ($array_text[$i] != '}')
                                                            {
                                                                $array_text[$i] = null;
                                                            }
                                                        else
                                                            {
                                                                break;
                                                            }
                                                    }

                                                $final_text = implode("", $array_text);
                                                $message = json_decode($final_text);

                                                if ($message):
                                                    $err_msg = [];
                                                    foreach ($message->errors ?? [] as $err)
                                                    {
                                                        $err_msg[] = $err;
                                                    }

                                                    $info = [
                                                        'message' => __('Order creation failed'),
                                                        'info' => __($message->message),
                                                        'errors' => current($err_msg)
                                                    ];
                                                endif;
                                            }
                                        ?>

                                        <tr>
                                            <td><?php echo e($order->id); ?></td>
                                            <td>
                                                <a class="order-link" href="<?php echo e(route('tenant.admin.product.order.manage.view', $order->order_id)); ?>" target="_blank"><?php echo e($order->order_id); ?></a>
                                            </td>
                                            <td class="text-capitalize"><?php echo e($order->gateway); ?></td>
                                            <td>
                                                <span class="text-capitalize badge <?php echo e($order->status == 'success' ? 'bg-success' : 'bg-danger'); ?>"><?php echo e($order->status); ?></span>
                                            </td>
                                            <td>
                                                <?php $__currentLoopData = $info ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(is_array($item)): ?>
                                                        <div class="d-flex gap-1">
                                                            <p class="text-capitalize text-danger"><strong><?php echo e(str_replace('_',' ', $index)); ?>:</strong></p>
                                                            <ol>
                                                                <?php $__currentLoopData = $item ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <li><?php echo e($value); ?></li>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </ol>
                                                        </div>
                                                    <?php else: ?>
                                                        <p class="text-capitalize"><strong><?php echo e(str_replace('_',' ', $index)); ?>:</strong> <?php echo e($item); ?></p>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </td>
                                            <td>
                                                <p><?php echo e($order->created_at?->format('d-m-Y H:i A')); ?></p>
                                                <p><small><?php echo e($order->created_at?->diffForHumans(parts: 2)); ?></small></p>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="6" class="text-center"><?php echo e(__('No Data Available')); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="d-flex justify-content-end">
                            <?php echo $orders->links(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        (function ($) {
            "use strict";

            $(document).on('click', 'form button[type=submit]', function () {
                $(this).find('span').toggleClass('d-none');
            });
        })(jQuery)
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('tenant.admin.admin-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tupapcth/dukakiganjani.online/core/Modules/ShippingPlugin/Resources/views/backend/index.blade.php ENDPATH**/ ?>