<?php
    if (!isset($product)) {
        $product = null;
    }

    if (!isset($taxes)) {
        $taxes = [];
    }
?>

<div class="general-info-wrapper px-3">
    <h4 class="dashboard-common-title-two"> <?php echo e(__('Price Manage')); ?> </h4>
    <div class="general-info-form mt-0 mt-lg-4">
        <div class="dashboard-input mt-4">
            <label class="dashboard-label color-light mb-2"> <?php echo e(__("Accessibility")); ?> </label>
            <select name="accessibility" id="accessibility" class="form-control">
                <option value="paid" <?php echo e($product?->accessibility == 'paid' ? 'selected' : ''); ?>><?php echo e(__('Paid')); ?></option>

            </select>
        </div>

        <div id="tax-price-info" style="<?php echo e($product?->accessibility == 'free' ? 'display:none' : ''); ?>">
            <div class="dashboard-input mt-4">
                <label class="dashboard-label color-light mb-2"> <?php echo e(__("Tax")); ?> </label>
                <select name="tax" id="tax" class="form-control">
                    <option value=""><?php echo e(__('No tax applicable')); ?></option>
                    <?php $__currentLoopData = $taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($tax->id); ?>" <?php echo e($product?->tax == $tax->id ? 'selected' : ''); ?>><?php echo e($tax->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="dashboard-input mt-4">
                <label class="dashboard-label color-light mb-2"> <?php echo e(__("Regular Price")); ?> </label>
                <input type="text" class="form--control radius-10" value="<?php echo e($product?->regular_price); ?>" name="price"
                       placeholder="<?php echo e(__("Enter Regular Price...")); ?>">
                <small class="text-warning"><?php echo e(__("This price will display like this")); ?>

                    <del>( <?php echo e(site_currency_symbol()); ?>10)</del> <?php echo e(', '.__('If you add sale price too')); ?></small>
            </div>

            <div class="dashboard-input mt-4">
                <label class="dashboard-label color-light mb-2"> <?php echo e(__("Sale Price")); ?> </label>
                <input type="text" class="form--control radius-10" value="<?php echo e($product?->sale_price); ?>" name="sale_price"
                       placeholder="<?php echo e(__("Enter Sale Price...")); ?>">
                <small><?php echo e(__("This will be your product selling price")); ?></small>
            </div>

            <div class="dashboard-input mt-4">
                <label class="dashboard-label color-light mb-2"> <?php echo e(__("Free Date")); ?> <sup
                        class="text-primary"><?php echo e(__('(Optional)')); ?></sup> </label>
                <input type="date" class="form--control radius-10 flatpickr" id="free_date"
                       value="<?php echo e($product?->free_date ?? ""); ?>" name="free_date"
                       placeholder="<?php echo e(__("Select free date...")); ?>">
                <small><?php echo e(__('This product will be free until this selected date is over')); ?></small>
            </div>

            <div class="dashboard-input mt-4">
                <label class="dashboard-label color-light mb-2"> <?php echo e(__("Promotional Date")); ?> <sup
                        class="text-primary"><?php echo e(__('(Optional)')); ?></sup> </label>
                <input type="date" class="form--control radius-10 flatpickr" id="promotional_date"
                       value="<?php echo e($product?->promotional_date ?? ""); ?>" name="promotional_date"
                       placeholder="<?php echo e(__("Select promotional date...")); ?>">
                <small><?php echo e(__('Promotional discounted price will be applied on this product until this selected date is over')); ?></small>
            </div>

            <div class="dashboard-input mt-4">
                <label class="dashboard-label color-light mb-2"> <?php echo e(__("Promotional Price")); ?> </label>
                <input type="text" class="form--control radius-10" value="<?php echo e($product?->promotional_price); ?>"
                       name="promotional_price" placeholder="<?php echo e(__("Enter promotional price...")); ?>">
                <small><?php echo e(__("This price will be applied on this product during the promotional time period")); ?></small>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /data/sdmkinga/ecommerce-v4.sdmkingagroup.com/core/Modules/DigitalProduct/Resources/views/components/product-price.blade.php ENDPATH**/ ?>