<?php //cbef53dbb28b597ae8c3e687e61610e3
/** @noinspection all */

namespace Stancl\Tenancy\Database\Models {

    use App\Models\Tenant as ModelsTenant;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_Tenant_QB;
    use LaravelIdea\Helper\Stancl\Tenancy\Database\Models\_IH_Domain_C;
    use LaravelIdea\Helper\Stancl\Tenancy\Database\Models\_IH_Domain_QB;
    use LaravelIdea\Helper\Stancl\Tenancy\Database\Models\_IH_ImpersonationToken_C;
    use LaravelIdea\Helper\Stancl\Tenancy\Database\Models\_IH_ImpersonationToken_QB;
    use LaravelIdea\Helper\Stancl\Tenancy\Database\Models\_IH_TenantPivot_C;
    use LaravelIdea\Helper\Stancl\Tenancy\Database\Models\_IH_TenantPivot_QB;
    use LaravelIdea\Helper\Stancl\Tenancy\Database\Models\_IH_Tenant_C;
    use LaravelIdea\Helper\Stancl\Tenancy\Database\Models\_IH_Tenant_QB as Models_IH_Tenant_QB;
    
    /**
     * @property int $id
     * @property string $domain
     * @property string $tenant_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property ModelsTenant $tenant
     * @method BelongsTo|_IH_Tenant_QB tenant()
     * @method static _IH_Domain_QB onWriteConnection()
     * @method _IH_Domain_QB newQuery()
     * @method static _IH_Domain_QB on(null|string $connection = null)
     * @method static _IH_Domain_QB query()
     * @method static _IH_Domain_QB with(array|string $relations)
     * @method _IH_Domain_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Domain_C|Domain[] all()
     * @ownLinks tenant_id,\App\Models\Tenant,id
     * @mixin _IH_Domain_QB
     */
    class Domain extends Model {}
    
    /**
     * @property string $token
     * @property string $tenant_id
     * @property string $user_id
     * @property string $auth_guard
     * @property string $redirect_url
     * @property Carbon $created_at
     * @method static _IH_ImpersonationToken_QB onWriteConnection()
     * @method _IH_ImpersonationToken_QB newQuery()
     * @method static _IH_ImpersonationToken_QB on(null|string $connection = null)
     * @method static _IH_ImpersonationToken_QB query()
     * @method static _IH_ImpersonationToken_QB with(array|string $relations)
     * @method _IH_ImpersonationToken_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ImpersonationToken_C|ImpersonationToken[] all()
     * @ownLinks tenant_id,\App\Models\Tenant,id
     * @mixin _IH_ImpersonationToken_QB
     */
    class ImpersonationToken extends Model {}
    
    /**
     * @property string $id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property array|null $data
     * @property int|null $user_id
     * @property string|null $theme_slug
     * @property int|null $renew_status
     * @property int $is_renew
     * @property string|null $start_date
     * @property string|null $expire_date
     * @property string|null $unique_key
     * @property int $cleanup
     * @method static Models_IH_Tenant_QB onWriteConnection()
     * @method Models_IH_Tenant_QB newQuery()
     * @method static Models_IH_Tenant_QB on(null|string $connection = null)
     * @method static Models_IH_Tenant_QB query()
     * @method static Models_IH_Tenant_QB with(array|string $relations)
     * @method Models_IH_Tenant_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Tenant_C|Tenant[] all()
     * @ownLinks user_id,\App\Models\User,id
     * @foreignLinks id,\Stancl\Tenancy\Database\Models\Domain,tenant_id|id,\App\Models\TenantUniqueKey,tenant_id|id,\App\Models\PaymentLogs,tenant_id|id,\App\Models\TenantException,tenant_id|id,\Modules\Wallet\Entities\WalletTenantList,tenant_id
     * @mixin Models_IH_Tenant_QB
     */
    class Tenant extends Model {}
    
    /**
     * @method static _IH_TenantPivot_QB onWriteConnection()
     * @method _IH_TenantPivot_QB newQuery()
     * @method static _IH_TenantPivot_QB on(null|string $connection = null)
     * @method static _IH_TenantPivot_QB query()
     * @method static _IH_TenantPivot_QB with(array|string $relations)
     * @method _IH_TenantPivot_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TenantPivot_C|TenantPivot[] all()
     * @mixin _IH_TenantPivot_QB
     */
    class TenantPivot extends Model {}
}